#ifdef GL_ES
precision highp float;
#endif

// output from the vertex shader (fragment color and texture coordinates)
varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

uniform vec2 u_shift;

const int gauss_radius = 11;
float gauss_filter[gauss_radius];

void main() {
	gauss_filter[0]  = 0.0402;
	gauss_filter[1]  = 0.0623;
	gauss_filter[2]  = 0.0877;
	gauss_filter[3]  = 0.1120;
	gauss_filter[4]  = 0.1297;
	gauss_filter[5]  = 0.1362;
	gauss_filter[6]  = 0.1297;
	gauss_filter[7]  = 0.1120;
	gauss_filter[8]  = 0.0877;
	gauss_filter[9]  = 0.0623;
	gauss_filter[10] = 0.0402;

	float blur_factor = v_fragmentColor.a;

	vec2 shift = u_shift * blur_factor;

	float half_gauss_radius = float(int(gauss_radius/2));

	//vec2 texCoord = v_texCoord.xy - float(int(gauss_radius/2)) * shift;
	vec4 color = vec4(0.0);
	for (int y = 0; y < gauss_radius; ++y) {
		for (int x = 0; x < gauss_radius; ++x) {
			vec2 texCoord = v_texCoord.xy + vec2(-half_gauss_radius + float(x), -half_gauss_radius + float(y)) * shift.xy;
			color += gauss_filter[x] * gauss_filter[y] * texture2D(CC_Texture0, texCoord);
		}
	}
	gl_FragColor = color;
}
